#ifndef UruchamianieAplikacjiH
#define UruchamianieAplikacjiH

#include"stdafx.h"

enum Priorities 
{
	prIdle=IDLE_PRIORITY_CLASS,
	prBelowNormal=BELOW_NORMAL_PRIORITY_CLASS,
	prNormal=NORMAL_PRIORITY_CLASS,
	prAboveNormal=ABOVE_NORMAL_PRIORITY_CLASS,
	prHigh=HIGH_PRIORITY_CLASS,
	prRealtime=REALTIME_PRIORITY_CLASS
};
//Podobny do TWindowState, ale dodany swHide i wartosci odpowiadaja staym z WinAPI
enum WindowStyles 
{
	swNormal=SW_NORMAL,
	swHide=SW_HIDE,
	swMaximize=SW_MAXIMIZE,
	swMinimize=SW_MINIMIZE
};

class CCreateProcess
{
private:
   CString fileName;
   CString directory;
   bool defaultPosition;
   bool defaultSize;
protected:
	Priorities priority;
	int left, top, width, height;
	WindowStyles windowStyle;
	PROCESS_INFORMATION processInformation;
public:
	CCreateProcess();
	bool Execute();
	bool ExecuteAndWait();

	// modyfikatory i akcesory
	
	//void SetProcessInformation(PROCESS_INFORMATION newProcessInformation) {processInformation = newProcessInformation;}
	PROCESS_INFORMATION GetProcessInformation() const {return processInformation;}

	CString GetFileName() const {return fileName;}
	void SetFileName(CString newFileName) {fileName = newFileName;}

	CString GetDirectory() const {return directory;}
	void SetDirectory(CString newDirectory) {directory = newDirectory;}

	int GetLeft() const {return left;}
	void SetLeft(int newLeft) {left = newLeft;}
	int GetTop() const {return top;}
	void SetTop(int newTop) {top = newTop;}
	int GetWidth() const {return width;}
	void SetWidth(int newWidth) {width = newWidth;}
	int GetHeight() const {return height;}
	void SetHeight(int newHeight) {height = newHeight;}

	Priorities GetPriorities() const {return priority;}
	void SetPriorities(Priorities newPriority) {priority = newPriority;}

	bool GetDefaultPosition() const {return defaultPosition;}
	void SetDefaultPosition(bool newDefaultPosition) {defaultPosition = newDefaultPosition;}

	bool GetDefaultSize() const {return defaultSize;}
	void SetDefaultSize(bool newDefaultSize) {defaultSize = newDefaultSize;}

	WindowStyles GetWindowStyle() const {return windowStyle;}
	void SetWindowStyle(WindowStyles newWindowStyle) {windowStyle = newWindowStyle;}
};


#endif